clear all;
close all;
clc;

%Caricamento delle matrici O/D e della mappatura
load 'IMQ2013_zonecampionarie';
fprintf('File MAT di riferimento:  IMQ2013_zonecampionarie.mat\n');
 
%Ottenimento del nuovo elenco delle zone
[empty,NEWzone] = xlsread('ESTRAZIONE.csv','A2:A210');
NEWzone = string(NEWzone);

%Estrazione delle nuove matrici
[ESTR_ResPIEmPrIGt] = estrazione(ResPIEmPrIGt,NEWzone,zoneA);
[ESTR_ResPIEmPrIGsr] = estrazione(ResPIEmPrIGsr,NEWzone,zoneA);
[ESTR_ResTOmPrIGt] = estrazione(ResTOmPrIGt,NEWzone,zoneA);
[ESTR_ResTOmPrIGsr] = estrazione(ResTOmPrIGsr,NEWzone,zoneA);
[ESTR_ResPIEmPrOPt] = estrazione(ResPIEmPrOPt,NEWzone,zoneA);
[ESTR_ResTOmPrOPt] = estrazione(ResTOmPrOPt,NEWzone,zoneA);
[ESTR_ResPIEmPuIGt] = estrazione(ResPIEmPuIGt,NEWzone,zoneA);
[ESTR_ResPIEmPuIGsr] = estrazione(ResPIEmPuIGsr,NEWzone,zoneA);
[ESTR_ResTOmPuIGt] = estrazione(ResTOmPuIGt,NEWzone,zoneA);
[ESTR_ResTOmPuIGsr] = estrazione(ResTOmPuIGsr,NEWzone,zoneA);
[ESTR_ResPIEmPuOPt] = estrazione(ResPIEmPuOPt,NEWzone,zoneA);
[ESTR_ResTOmPuOPt] = estrazione(ResTOmPuOPt,NEWzone,zoneA);

%Salvataggio delle nuove matrici
save IMQ2013_estrazione NEWzone ESTR_ResPIEmPrIGt ESTR_ResPIEmPrIGsr ESTR_ResTOmPrIGt ESTR_ResTOmPrIGsr ESTR_ResPIEmPrOPt ESTR_ResTOmPrOPt ESTR_ResPIEmPuIGt ESTR_ResPIEmPuIGsr ESTR_ResTOmPuIGt ESTR_ResTOmPuIGsr ESTR_ResPIEmPuOPt ESTR_ResTOmPuOPt;
fprintf('FILE MAT CREATO:  IMQ2013_estrazione.mat\n');

%Definzizione della funzione di estrazione della matrice
function [newMATR] = estrazione(matrORIG,Nzone,Ozone);
for i=1:length(Nzone);
    for j=1:length(Nzone);
        newMATR(i,j) = matrORIG(find(Ozone==Nzone(i)),find(Ozone==Nzone(j)));
    end;
end;
end
